package jamezo97.clonecraft;

import jamezo97.clonecraft.block.TileEntityCentrifuge;
import jamezo97.clonecraft.block.TileEntityDNASequencer;
import jamezo97.clonecraft.block.TileEntityGeneExtractor;
import jamezo97.clonecraft.block.TileEntityLifeInducer;
import jamezo97.clonecraft.entity.clone.EntityClone;
import jamezo97.clonecraft.gui.ContainerCentrifuge;
import jamezo97.clonecraft.gui.ContainerDNASequencer;
import jamezo97.clonecraft.gui.ContainerGeneExtractor;
import jamezo97.clonecraft.gui.ContainerLifeInducer;
import jamezo97.clonecraft.gui.ContainerTransferPlayerItems;
import jamezo97.clonecraft.gui.GuiCentrifuge;
import jamezo97.clonecraft.gui.GuiDNASequencer;
import jamezo97.clonecraft.gui.GuiGeneExtractor;
import jamezo97.clonecraft.gui.GuiLifeInducer;
import jamezo97.clonecraft.gui.GuiTransferPlayerItems;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import cpw.mods.fml.common.network.IGuiHandler;

public class GuiHandler implements IGuiHandler{

	
	@Override
	public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
		if(ID == CENTRIFUGE){
			TileEntity te = world.getBlockTileEntity(x, y, z);
			if(te != null && te instanceof TileEntityCentrifuge){
				return new ContainerCentrifuge(player.inventory, (TileEntityCentrifuge)te);
			}else{
				Logger.log("Server: TileEntityCentrifuge does not exist at " + x + ", " + y + ", " + z);
			}
		}else if(ID == LIFEINDUCER){
			TileEntity te = world.getBlockTileEntity(x, y, z);
			if(te != null && te instanceof TileEntityLifeInducer){
				return new ContainerLifeInducer(player.inventory, (TileEntityLifeInducer)te);
			}else{
				Logger.log("Server: TileEntityCentrifuge does not exist at " + x + ", " + y + ", " + z);
			}
		}else if(ID == CLONEINVEN){
			Entity e = world.getEntityByID(x);
			if(e instanceof EntityClone){
				EntityClone clone = (EntityClone)e;
				return new ContainerTransferPlayerItems(player, clone);
			}else{
				System.out.println("Entity doesn't exist on server");
			}
		}else if(ID == SEQUENCER){
			TileEntity te = world.getBlockTileEntity(x, y, z);
			if(te != null && te instanceof TileEntityDNASequencer){
				return new ContainerDNASequencer(player.inventory, (TileEntityDNASequencer)te);
			}else{
				Logger.log("Server: TileEntityDNASequencer does not exist at " + x + ", " + y + ", " + z);
			}
		}else if(ID == GENEEXTRACTOR){
			TileEntity te = world.getBlockTileEntity(x, y, z);
			if(te != null && te instanceof TileEntityGeneExtractor){
				return new ContainerGeneExtractor(player.inventory, (TileEntityGeneExtractor)te);
			}else{
				Logger.log("Server: TileEntityGeneExtractor does not exist at " + x + ", " + y + ", " + z);
			}
		}/*else if(ID == SPLICER){
			TileEntity te = world.getBlockTileEntity(x, y, z);
			if(te != null && te instanceof TileEntitySplicer){
				return new ContainerSplicer(player.inventory, (TileEntitySplicer)te);
			}else{
				System.out.println("Server: TileEntitySplicer does not exist at " + x + ", " + y + ", " + z);
			}
		}else if(ID == INCUBATOR){
			TileEntity te = world.getBlockTileEntity(x, y, z);
			if(te != null && te instanceof TileEntityIncubator){
				return new ContainerIncubator(player.inventory, (TileEntityIncubator)te);
			}else{
				System.out.println("Server: TileEntityIncubator does not exist at " + x + ", " + y + ", " + z);
			}
		}else if(ID == CLONER){
			TileEntity te = world.getBlockTileEntity(x, y, z);
			if(te != null && te instanceof TileEntityDnaCloner){
				System.out.println("Ret1");
				return new ContainerDnaCloner(player.inventory, (TileEntityDnaCloner)te);
			}else{
				System.out.println("Server: TileEntityDnaCloner does not exist at " + x + ", " + y + ", " + z);
			}
		}*/
		return null;
	}

	@Override
	public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
		if(ID == CENTRIFUGE){
			TileEntity te = world.getBlockTileEntity(x, y, z);
			if(te != null && te instanceof TileEntityCentrifuge){
				return new GuiCentrifuge(player, (TileEntityCentrifuge)te);
			}else{
				System.out.println("Client: TileEntityCentrifuge does not exist at " + x + ", " + y + ", " + z);
			}
		}else if(ID == LIFEINDUCER){
			TileEntity te = world.getBlockTileEntity(x, y, z);
			if(te != null && te instanceof TileEntityLifeInducer){
				return new GuiLifeInducer(player.inventory, (TileEntityLifeInducer)te);
			}else{
				System.out.println("Client: TileEntityLifeInducer does not exist at " + x + ", " + y + ", " + z);
			}
		}else if(ID == CLONEINVEN){
			Entity e = world.getEntityByID(x);
			if(e instanceof EntityClone){
				EntityClone clone = (EntityClone)e;
				return new GuiTransferPlayerItems(clone, player, false);
			}else{
				System.out.println("EntityClone doesn't exist on client");
			}
		}else if(ID == SEQUENCER){
			TileEntity te = world.getBlockTileEntity(x, y, z);
			if(te != null && te instanceof TileEntityDNASequencer){
				return new GuiDNASequencer(player.inventory, (TileEntityDNASequencer)te);
			}else{
				System.out.println("Client: TileEntityDNASequencer does not exist at " + x + ", " + y + ", " + z);
			}
		}else if(ID == GENEEXTRACTOR){
			TileEntity te = world.getBlockTileEntity(x, y, z);
			if(te != null && te instanceof TileEntityGeneExtractor){
				return new GuiGeneExtractor(player.inventory, (TileEntityGeneExtractor)te);
			}else{
				System.out.println("Client: TileEntityGeneExtractor does not exist at " + x + ", " + y + ", " + z);
			}
		}/*else if(ID == PERSONFINDER){
			return new GuiCloneTracker();
		}else if(ID == SPLICER){
			TileEntity te = world.getBlockTileEntity(x, y, z);
			if(te != null && te instanceof TileEntitySplicer){
				return new GuiSplicer(player.inventory, (TileEntitySplicer)te);
			}else{
				System.out.println("Client: TileEntitySplicer does not exist at " + x + ", " + y + ", " + z);
			}
		}else if(ID == INCUBATOR){
			TileEntity te = world.getBlockTileEntity(x, y, z);
			if(te != null && te instanceof TileEntityIncubator){
				return new GuiIncubator(player.inventory, (TileEntityIncubator)te);
			}else{
				System.out.println("Server: TileEntityIncubator does not exist at " + x + ", " + y + ", " + z);
			}
		}else if(ID == CLONER){

			TileEntity te = world.getBlockTileEntity(x, y, z);
			if(te != null && te instanceof TileEntityDnaCloner){
				System.out.println("Ret2");
				return new GuiDnaCloner(player.inventory, (TileEntityDnaCloner)te);
			}else{
				System.out.println("Server: TileEntityDnaCloner does not exist at " + x + ", " + y + ", " + z);
			}
		}*/
		return null;
	}
	
	
//	public static int CLONER = 6;
//	public static int INCUBATOR = 4;
//	public static int SPLICER = 4;
	public static int GENEEXTRACTOR = 5;
	public static int SEQUENCER = 4;
	public static int PERSONFINDER = 3;
	
	public static int CLONEINVEN = 2;
	public static int LIFEINDUCER = 1;
	public static int CENTRIFUGE = 0;

}
